-- RMTUI
-- Author: Zur13
-- DateCreated: 12/1/2018 1:55:47 PM
-- Copyright 2019, Zur13, All rights reserved
--------------------------------------------------------------

include( "InstanceManager" );

local m_KeyStackIM:table = InstanceManager:new( "KeyEntry", "KeyColorImage", Controls.KeyStack );
local m_resSStackIM:table = InstanceManager:new( "ResEntry", "RmtStackRes", Controls.RmtStackResS );
local m_resLStackIM:table = InstanceManager:new( "ResEntry", "RmtStackRes", Controls.RmtStackResL );

IsBtnAddedRmt = false; -- flag to indicate the button was added to the top panel

local isShownRmt = false;
local transpBackground = false;

local MOVEMENT_PATH = UILens.CreateLensLayerHash( "Movement_Path" );--LensLayers.MOVEMENT_PATH ;
local NUMBERS = UILens.CreateLensLayerHash( "Numbers" );--LensLayers.NUMBERS;
local ATTACK_RANGE = UILens.CreateLensLayerHash( "Attack_Range" );--LensLayers.ATTACK_RANGE ;

local MAP_HEX_MASK = UILens.CreateLensLayerHash( "Map_Hex_Mask" );--LensLayers.MAP_HEX_MASK ;
local LENS_LAYER = UILens.CreateLensLayerHash( "Hex_Coloring_Water_Availablity" );--LensLayers.HEX_COLORING_WATER_AVAILABLITY;
local btnClick = false;

local targetPlotId = nil;
local targetPlotIds = {};
local radius = 3;

local colCityCentersOnly = false; -- color only city center tiles
local importantResourcesOnly = true; -- ignore bonus resource tiles
local enableSuggestions = false; -- mark notable tiles
local disableDimming = false; -- disable dimming of plots outside theradius
local disableIntersects = false; -- disable multiple radiuses color intersects





local multiRadius = false; -- highlight plots in both new and previous radiuses
local maxRadiuses = 8;

local radCol				 = UI.GetColorValue("COLOR_RMT_NOTHING"); -- base color
local radColRes				 = UI.GetColorValue("COLOR_RMT_RES"); -- resource color
local radColNotPass			 = UI.GetColorValue("COLOR_RMT_NOT_PASS");  -- not passable terrain 
local radColCityPretend		 = UI.GetColorValue("COLOR_RMT_IN_CITY_RNG");  -- in range of another city but not owned yet
local radColCityOwned		 = UI.GetColorValue("COLOR_RMT_CITY_OWND");  -- in range of another city and already owned
local radColCityResPretend	 = UI.GetColorValue("COLOR_RMT_RES_IN_RNG"); -- resorce on another city hex which is not owned yet
local radColCityResOwned	 = UI.GetColorValue("COLOR_RMT_RES_OWND"); -- resorce on another city hex which is not owned yet
local radColCityResWater	 = UI.GetColorValue("COLOR_RMT_RES_WATER"); -- resorce on a tile with fresh water
local radColWater			 = UI.GetColorValue("COLOR_RMT_WATER"); -- water is available here
local radColCityCenter		 = UI.GetColorValue("COLOR_RMT_CITY_CNTR"); -- resorce on a tile with fresh water

local plotColorStor = {}; -- key - radius center plotId; value table: key - color key; value - list of plotIds

local colorPlot = {}; -- plot ids by color key for currently processed radius
local radiusPlots = {}; -- all plots in currently processed radius

local notDimPlot = {}; -- all plot ids which should not be dimmed

local radiusYields = {}; -- key - radius center plotId; value - table { key - YieldType.  ; value - yield count }

local radiusSRes = {}; -- strategic resources table: key - radius center plotId; value - table { key - ResType.  ; value - res count }
local radiusLRes = {}; -- luxury    resources table: key - radius center plotId; value - table { key - ResType.  ; value - res count }

local FixUiMode;
local HighlightMapHexes;
local RefreshRadiusCB;
local UpdateUiCounters;

include( "UserSettings" );

--************************************************************
-- Get index of plotId in old plots table
local function getOldPlotKey( plotId )
	for key, value in pairs( targetPlotIds ) do
		if value == plotId then
			return key;
		end
	end
	return nil;
end

--************************************************************
-- update position or insert as first ploId in old plots table
local function updateOldPlotId( plotId )
	local oldPlotKey = getOldPlotKey( plotId );
	if oldPlotKey ~= nil then
		table.remove( targetPlotIds, oldPlotKey );
		
		radiusYields[oldPlotKey] = nil;
		radiusSRes[oldPlotKey] = nil;
		radiusLRes[oldPlotKey] = nil;
		plotColorStor[oldPlotKey] = nil;

	elseif table.count( targetPlotIds ) >= maxRadiuses then
		table.remove( targetPlotIds );
	end
	table.insert( targetPlotIds, 1, plotId );
end

--************************************************************
-- Remove plotId from old plots table
local function removeOldPlotId( plotId )
	local oldPlotKey = getOldPlotKey( plotId );
	if oldPlotKey ~= nil then
		table.remove( targetPlotIds, oldPlotKey );
		radiusYields[plotId] = nil;
		plotColorStor[plotId] = nil;
		radiusSRes[plotId] = nil;
		radiusLRes[plotId] = nil;
	end
end

--************************************************************
-- Get second radius plotId if any
local function getOldRadiusPlotId( )
	return targetPlotIds[2];
end

--************************************************************
-- Center right the window
local function SetAnchorCentr()
	print("SetAnchorCentr");
	Controls.RmtContentContainer:SetAnchor("R,T");
	Controls.RmtSpawnDlgBG:SetAnchor("R,T");
	Controls.RmtSpawnDlgContainer:SetAnchor("R,T");

	Controls.RmtContentContainer:ReprocessAnchoring();
	Controls.RmtSpawnDlgBG:ReprocessAnchoring();
	Controls.RmtSpawnDlgContainer:ReprocessAnchoring();

	--Controls.RmtContentContainer:SetOffsetX(530);
	Controls.RmtSpawnDlgBG:SetOffsetX(530);
	Controls.RmtSpawnDlgContainer:SetOffsetX(530);

	if not Controls.RmtWndPosCentrCB:IsChecked() then
		Controls.RmtWndPosCentrCB:SetCheck(true);
	end
	Controls.RmtWndPosLeftCB:SetCheck(false);
	Controls.RmtWndPosRightCB:SetCheck(false);
end

--************************************************************
-- Left the window
local function SetAnchorLeft()
	print("SetAnchorLeft");
	SetAnchorCentr();
	Controls.RmtContentContainer:SetAnchor("L,T");
	Controls.RmtSpawnDlgBG:SetAnchor("L,T");
	Controls.RmtSpawnDlgContainer:SetAnchor("L,T");

	Controls.RmtContentContainer:ReprocessAnchoring();
	Controls.RmtSpawnDlgBG:ReprocessAnchoring();
	Controls.RmtSpawnDlgContainer:ReprocessAnchoring();

	--Controls.RmtContentContainer:SetOffsetX(30);
	Controls.RmtSpawnDlgBG:SetOffsetX(20);
	Controls.RmtSpawnDlgContainer:SetOffsetX(20);

	if not Controls.RmtWndPosLeftCB:IsChecked() then
		Controls.RmtWndPosLeftCB:SetCheck(true);
	end
	Controls.RmtWndPosCentrCB:SetCheck(false);
	Controls.RmtWndPosRightCB:SetCheck(false);
end

--************************************************************
-- Right the window
local function SetAnchorRight()
	print("SetAnchorRight");
	SetAnchorCentr();
	Controls.RmtContentContainer:SetAnchor("R,T");
	Controls.RmtSpawnDlgBG:SetAnchor("R,T");
	Controls.RmtSpawnDlgContainer:SetAnchor("R,T");

	Controls.RmtContentContainer:ReprocessAnchoring();
	Controls.RmtSpawnDlgBG:ReprocessAnchoring();
	Controls.RmtSpawnDlgContainer:ReprocessAnchoring();

	--Controls.RmtContentContainer:SetOffsetX(30);
	Controls.RmtSpawnDlgBG:SetOffsetX(20);
	Controls.RmtSpawnDlgContainer:SetOffsetX(20);

	if not Controls.RmtWndPosRightCB:IsChecked() then
		Controls.RmtWndPosRightCB:SetCheck(true);
	end
	Controls.RmtWndPosLeftCB:SetCheck(false);
	Controls.RmtWndPosCentrCB:SetCheck(false);
end

--************************************************************
-- Add the RMT button to the top panel
local function AddButtonToTopPanel()
	if not IsBtnAddedRmt then
		local tPanRightStack:table = ContextPtr:LookUpControl("/InGame/TopPanel/RightContents"); -- top panel right stack where clock civilopedia and menu is
		if tPanRightStack ~= nil then
			Controls.RmtLaunchBarBtn:ChangeParent(tPanRightStack);
			tPanRightStack:AddChildAtIndex(Controls.RmtLaunchBarBtn, 3);
			tPanRightStack:CalculateSize();
			tPanRightStack:ReprocessAnchoring();
			IsBtnAddedRmt = true;
		end
	end
end

--************************************************************
-- Callaback of the load game UI event
local function OnLoadGameViewStateDone()
	AddButtonToTopPanel();
end

--******************************************************************************
-- Change interface mode to selection
FixUiMode = function( )
	local cMode = UI.GetInterfaceMode();
	if not isShownRmt and cMode ~= InterfaceModeTypes.SELECTION then
		--print("FixUiMode() 1");
		UI.SetInterfaceMode( InterfaceModeTypes.SELECTION );
	elseif isShownRmt then
		--print("FixUiMode() 2");
		UI.SetInterfaceMode( InterfaceModeTypes.SELECTION );
		UI.SetInterfaceMode( InterfaceModeTypes.WB_SELECT_PLOT );
		--UI.SetInterfaceMode( InterfaceModeTypes.VIEW_MODAL_LENS );
 	end
end

--******************************************************************************
-- Handle external UI mod change event
function OnUiModChange( )
	local cMode = UI.GetInterfaceMode();
	if isShownRmt and cMode == InterfaceModeTypes.SELECTION then
		--print("FixUiMode() 2");
		--UI.SetInterfaceMode( InterfaceModeTypes.SELECTION );
		UI.SetInterfaceMode( InterfaceModeTypes.WB_SELECT_PLOT );
		--UI.SetInterfaceMode( InterfaceModeTypes.VIEW_MODAL_LENS );
 	end
end

--******************************************************************************
local function HideDlg()
	--print("HideDup() 1");
	if not Controls.RmtSpawnDlgContainer:IsHidden() then
		Controls.RmtSpawnDlgContainer:SetHide( true );
		Controls.RmtSpawnDlgBG:SetHide( true );
		--Controls.RmtSpawnDlg_CollapseAnim:SetToBeginning();
		--Controls.RmtSpawnDlg_CollapseAnim:Play();
	end
	--print("HideDup() 2");
	--Controls.GUI_UnitCheats_SpawnDlgContainer:SetHide( true );
	--print("HideDup() 3");
	
	UILens.ClearLayerHexes( MOVEMENT_PATH );
	UILens.ClearLayerHexes( NUMBERS );
	UILens.ClearLayerHexes( ATTACK_RANGE );
	
	UILens.ClearLayerHexes( LENS_LAYER );
	UILens.ToggleLayerOff( LENS_LAYER );

	UILens.ClearLayerHexes( MAP_HEX_MASK );
	UILens.ToggleLayerOff( MAP_HEX_MASK );

	--print("HideDup() 4");
	FixUiMode();
	--print("HideDup() 5");

	LuaEvents.RmtClearSettlementRecommendations();
end

--******************************************************************************
local function ShowDlg()
	if Controls.RmtSpawnDlgContainer:IsHidden() then
	
		Controls.RmtSpawnDlgBG:SetHide( transpBackground );

		Controls.RmtSpawnDlgContainer:SetHide( false );
		--Controls.RmtSpawnDlg_ExpandAnim:SetToBeginning();
		--Controls.RmtSpawnDlg_ExpandAnim:Play();
	--else
		--Controls.GUI_UnitCheats_SpawnDlgContainer:SetHide( false );
	end
	UpdateUiCounters();
		-- Check if the appeal lens is already active. Needed to clear any modded lens
        --if UILens.IsLayerOn(LensLayers.HEX_COLORING_APPEAL_LEVEL) then
            ---- Unapply the appeal lens, so it can be cleared from the screen
            --UILens.SetActive("Default");
        --end
--
        --UILens.SetActive("Appeal");
		
	FixUiMode();

	RefreshRadiusCB();

	--UILens.ClearLayerHexes( LENS_LAYER )
	--if UILens.IsLayerOn( LENS_LAYER ) then
        --UILens.ToggleLayerOff( LENS_LAYER );
    --end
	UILens.ToggleLayerOn( LENS_LAYER );

	--HighlightMapHexes();
	--UILens.ToggleLayerOn(LENS_LAYER);
end


--************************************************************
-- calculate tiles and compare/refresh old tile counter
local oldTileCounters = {};
local calculateTiles = function ( tileColorKey )
	local oldTileCounter = oldTileCounters[tileColorKey];
	local newTileCounter = 0;
	local diffTileCounter = 0;

	if colorPlot[tileColorKey] ~= nil then
		newTileCounter = table.count(colorPlot[tileColorKey]); 
	end

	if oldTileCounter ~= nil then
		diffTileCounter = newTileCounter - oldTileCounter;
	end
	
	-- update old counter
	oldTileCounters[tileColorKey] = newTileCounter;

	return oldTileCounter, newTileCounter, diffTileCounter;
end

--************************************************************
-- calculate yields in radius
local calculateYields = function ( radiusPlots, yieldStor )
	local localPlayer   :number = Game.GetLocalPlayer();
	local localPlayerVis:table = PlayersVisibility[localPlayer];

	--local oldYieldCounter = oldYieldCounters[yieldType];
	--local diffYieldCounter = 0;
	
	for i, yType in pairs( { YieldTypes.FOOD , YieldTypes.PRODUCTION, YieldTypes.GOLD, YieldTypes.SCIENCE, YieldTypes.CULTURE, YieldTypes.FAITH } ) do 
		local newYieldCounter = 0;
		for i,iPlot in ipairs(radiusPlots) do 
			local idx = iPlot:GetIndex();
			local iX:number = iPlot:GetX();
			local iY:number = iPlot:GetY();

			local visible = true;
			if not ignoreVisibility and localPlayerVis ~= nil then
				visible = localPlayerVis:IsRevealed(iX, iY);
			end

			if visible and not iPlot:IsCity() and iPlot:IsOwned() == false then
				local yield = iPlot:GetYield( yType );
				if yield ~= nil then
					newYieldCounter = newYieldCounter + yield;
				end
			end
		end
		yieldStor[yType] = newYieldCounter;
	end

	--if oldYieldCounter ~= nil then
		--diffYieldCounter = newYieldCounter - oldYieldCounter;
	--end
	
	-- update old counter
	--oldYieldCounters[yieldType] = newYieldCounter;

	--return oldYieldCounter, newYieldCounter, diffYieldCounter;
end

--************************************************************
-- calculate resources in radius
local calculateRes = function ( radiusPlots, resStorS, resStorL )
	local localPlayer   :number = Game.GetLocalPlayer();
	local localPlayerVis:table = PlayersVisibility[localPlayer];
	
	for i,iPlot in ipairs(radiusPlots) do 
		local idx = iPlot:GetIndex();
		local iX:number = iPlot:GetX();
		local iY:number = iPlot:GetY();

		local visible = true;
		if not ignoreVisibility and localPlayerVis ~= nil then
			visible = localPlayerVis:IsRevealed(iX, iY);
		end

		if visible and not iPlot:IsCity() and iPlot:IsOwned() == false then
				
			local resType = iPlot:GetResourceType();
			if resType ~= nil then
				local res = GameInfo.Resources[resType];

				local visToPlayer = true;
				if not ignoreResourceVisibility  and resType ~= -1  and resType ~= nil then
					local resourceHash = GameInfo.Resources[resType].Hash;
					local localPlayer = Players[Game.GetLocalPlayer()];
					if (localPlayer ~= nil) then
						local playerResources = localPlayer:GetResources();
						visToPlayer = playerResources:IsResourceVisible(resourceHash);
					else 
						visToPlayer = false;
					end
				end

				if visToPlayer then
					if res ~= nil and res.ResourceClassType == "RESOURCECLASS_LUXURY" then
						if resStorL[resType] == nil then
							resStorL[resType] = 0;
						end
						resStorL[resType] = resStorL[resType] + 1;
					end	

					if res ~= nil and res.ResourceClassType == "RESOURCECLASS_STRATEGIC"  then
						if resStorS[resType] == nil then
							resStorS[resType] = 0;
						end
						resStorS[resType] = resStorS[resType] + 1;
					end	
				end
			end

		end
	end
	
end

--******************************************************************************
-- Update plots in radius
local function CollectData(plotId, isMainRadius)
	if plotId == nil then
		return;
	end

	local plot = Map.GetPlotByIndex(plotId);
	if plot ~= nil then
		-- HIghlight radius logic
		local mapWidth, mapHeight = Map.GetGridSize();
		local localPlayer   :number = Game.GetLocalPlayer();
		local localPlayerVis:table = PlayersVisibility[localPlayer];

		local selPlot = plot;
		local selPlotX:number = selPlot:GetX();
		local selPlotY:number = selPlot:GetY();

		radiusPlots = {};
		colorPlot = {};

		plotColorStor[plotId] = colorPlot;

		colorPlot[radCol] = {};
		colorPlot[radColRes] = {};
		colorPlot[radColNotPass] = {};
		colorPlot[radColCityPretend] = {};
		colorPlot[radColCityOwned] = {};
		colorPlot[radColCityResPretend] = {};
		colorPlot[radColCityResOwned] = {};
		colorPlot[radColCityResWater] = {};
		colorPlot[radColWater] = {};
		colorPlot[radColCityCenter] = {};
		
		
		--local radPlot = {}; -- all plot ids in radius
		--local cityPlot = {}; -- all plot ids with city centers in radius
		if isMainRadius then
			notDimPlot = {};
		end

		local cRadius = radius + 4; -- radius with cities which may affect
		local radiusCityPlots = {}; -- plots with cities which may affect plots in radius (city may be outside of radius)


		for x = selPlotX - cRadius, selPlotX + cRadius, 1 do
			for y = selPlotY - cRadius, selPlotY + cRadius, 1 do
				local iPlot:table = Map.GetPlot(x, y);
				if iPlot ~= nil then
					local idx = iPlot:GetIndex();
					local iX:number = iPlot:GetX();
					local iY:number = iPlot:GetY();
			
					local dist2:number = Map.GetPlotDistance(iX, iY, selPlotX, selPlotY);

					if dist2 <= radius then
						--print("Adding plot ### " , selPlotX, selPlotY, x, y, dist2 );
						table.insert(radiusPlots, iPlot);

						if isMainRadius then
							table.insert(notDimPlot, idx);
						end
					end
					if iPlot:IsCity() then
						table.insert(radiusCityPlots, iPlot);
					end
					
				end
			end
		end
			
		for i,iPlot in ipairs(radiusPlots) do 
			local isInCityRange = false; -- iPlot in another city range
			local idx = iPlot:GetIndex();
			local iX:number = iPlot:GetX();
			local iY:number = iPlot:GetY();

			-- check if iPlot is in another city range
			for j, cPlot in ipairs(radiusCityPlots) do 
				local cX:number = cPlot:GetX();
				local cY:number = cPlot:GetY();

				local dist:number = Map.GetPlotDistance(iX, iY, cX, cY);
				if dist <= 3 then
					isInCityRange = true;
					break;
				end
			end

			--print("Adding plot ###### " , selPlotX, selPlotY, iX, iY );
			
			local resType = iPlot:GetResourceType();
			
			if not ignoreResourceVisibility and resType ~= -1 and resType ~= nil then
				--print("ignoreResourceVisibility  ###### " , GameInfo.Resources, resType );
				local resourceHash = GameInfo.Resources[resType].Hash;
				local localPlayer = Players[Game.GetLocalPlayer()];
				if (localPlayer ~= nil) then
					local playerResources = localPlayer:GetResources();
					if not playerResources:IsResourceVisible(resourceHash) then
						resType = nil;
					end
				else 
					resType = nil;
				end
			end

			if importantResourcesOnly and resType ~= nil then
				--Finds bonus resources
				--local iResourcesInDB = 0;
				--eResourceType	= {};
				--eResourceClassType = {};
				local res = GameInfo.Resources[resType];
				--print("Resource found: ", res);
				if res ~= nil
					and res.ResourceClassType ~= "RESOURCECLASS_LUXURY" 
					and res.ResourceClassType ~= "RESOURCECLASS_STRATEGIC" 
				then
					--print("   |__ Ignore: ", res.Index, res.ResourceClassType);
					resType = nil;
				end	
			end

			local visible = true;
			if not ignoreVisibility and localPlayerVis ~= nil then
				visible = localPlayerVis:IsRevealed(iX, iY);
			end
			
			if visible and iPlot:IsCity() then
				table.insert(colorPlot[radColCityCenter], idx);
			elseif visible and resType ~= nil and resType >= 0 then
				-- resource hex
				if isInCityRange and iPlot:IsOwned() == false then					
					table.insert(colorPlot[radColCityResPretend], idx);
				elseif isInCityRange and iPlot:IsOwned() == true then
					table.insert(colorPlot[radColCityResOwned], idx);
				elseif iPlot:IsFreshWater() or iPlot:IsCoastalLand() then
					table.insert(colorPlot[radColCityResWater], idx);
				else
					table.insert(colorPlot[radColRes], idx);
				end
			elseif visible and isInCityRange and iPlot:IsOwned() == true then
				table.insert(colorPlot[radColCityOwned], idx);
			elseif visible and isInCityRange and iPlot:IsOwned() == false then
				table.insert(colorPlot[radColCityPretend], idx);
			elseif visible and iPlot:IsImpassable() then
				table.insert(colorPlot[radColNotPass], idx);			
			elseif visible and ( iPlot:IsFreshWater() or iPlot:IsCoastalLand() )then
				table.insert(colorPlot[radColWater], idx);
			elseif visible or ignoreVisibility == false then
				table.insert(colorPlot[radCol], idx);
			end

			
			--if iPlot:IsCity() then
				--table.insert(cityPlot, idx);
			--end
		end -- for i,iPlot in ipairs(radiusPlots) do 
		
		-- yields calculate
		radiusYields[plotId] = {}; -- remove prev radius yields
		local yieldStor = radiusYields[plotId];
		calculateYields( radiusPlots, yieldStor );
				
		-- res calculate
		radiusSRes[plotId] = {}; -- remove prev radius res
		radiusLRes[plotId] = {}; -- remove prev radius res
		local resStorS = radiusSRes[plotId];
		local resStorL = radiusLRes[plotId];
		calculateRes( radiusPlots, resStorS, resStorL );
	end
end

--******************************************************************************
-- Update map highlight
HighlightMapHexes = function ( )
	plotColorStor = {};
	radiusYields = {};
	radiusSRes = {};
	radiusLRes = {};

	if targetPlotId == nil then
	
		UpdateUiCounters();

		UILens.ClearLayerHexes( MOVEMENT_PATH );
		UILens.ClearLayerHexes( NUMBERS );
		UILens.ClearLayerHexes( ATTACK_RANGE );
	
		UILens.ClearLayerHexes(LENS_LAYER);

		UILens.ClearLayerHexes( MAP_HEX_MASK );   
		return;
	end
	if multiRadius then
		for i = #targetPlotIds, 1, -1 do
			local plotId = targetPlotIds[i]
			local isMain = plotId == targetPlotId;
			CollectData( plotId, isMain);
			UpdateUiCounters( isMain );
		end
	else
		CollectData( getOldRadiusPlotId(), false);
		UpdateUiCounters();

		CollectData( targetPlotId, true);
		UpdateUiCounters( true );
	end

	--if doubleRadius and oldTargetPlotId ~= nil and oldTargetPlotId ~= targetPlotId then
		--CollectData( false, oldTargetPlotId, false);
		--needToAppend = true;
	--end
	--CollectData( needToAppend, targetPlotId, true);
	

	UILens.ClearLayerHexes( MOVEMENT_PATH );
	UILens.ClearLayerHexes( NUMBERS );
	UILens.ClearLayerHexes( ATTACK_RANGE );
	
	UILens.ClearLayerHexes( LENS_LAYER );

	UILens.ClearLayerHexes( MAP_HEX_MASK );   

	local plot = Map.GetPlotByIndex(targetPlotId);
	--print("HighlightMapHexes #", 1, plot, getOldRadiusPlotId(), targetPlotId );
	if plot ~= nil then
		-- Obtain ordered list of plots.
		local variations	: table = {};	-- 2 to 3 values
		local pathPlots		: table = {};
		local eLocalPlayer	: number = Game.GetLocalPlayer();

		--check for unit position swap first
		local endPlotId   :number = targetPlotId;
		local startPlotId :number = targetPlotId;
		--if oldTargetPlotId ~= nil then
			--startPlotId = oldTargetPlotId;
		--end
		local lensNameBase = "MovementGood";
		--if UILens.IsLensActive(lensNameBase) then
			UILens.SetActive("Default");
		--end
		--if not UILens.IsLensActive(lensNameBase) then
			--UILens.SetActive(lensNameBase);	
		--end
		table.insert(pathPlots, startPlotId);

		table.insert(pathPlots, endPlotId);
		table.insert(variations, {lensNameBase.."_Origin",startPlotId} );
		--table.insert(variations, {lensNameBase.."_Counter", startPlotId} ); -- show counter pip
		--UI.AddNumberToPath( 1, startPlotId);
		table.insert(variations, {lensNameBase.."_Destination",endPlotId} );
		--table.insert(variations, {lensNameBase.."_Counter", endPlotId} ); -- show counter pip
		--UI.AddNumberToPath( 1, endPlotId);
		--UILens.SetLayerHexesPath(LensLayers.MOVEMENT_PATH, eLocalPlayer, pathPlots, variations);	
		UILens.SetLayerHexesPath(MOVEMENT_PATH, eLocalPlayer, pathPlots, variations);

		local workedPlots = {};
		-- HIghlight radius logic
		--print("HighlightMapHexes #", 2, targetPlotId, plot );
		
		for plotId, cPlots in pairs(plotColorStor) do
			if multiRadius or plotId == targetPlotId then
				colorPlot = cPlots;
				--print("HighlightMapHexes for radius", 2.5, plotId );
				for color, plots in pairs(colorPlot) do
					--print("HighlightMapHexes #", 3, color, table.count(plots) );
					if table.count(plots) > 0 then
						--local intersect = false;
						local interPlots;
						if disableIntersects then
							interPlots = {};
							for i, plot in ipairs(plots) do
								if workedPlots[plot] == nil then
									table.insert(interPlots, plot);
								else
									--print("Plot was already colored,", plot);
									--intersect = true;
								end
								workedPlots[plot]  = plot;
							end
						else
							interPlots = plots;
						end

						--if not disableIntersects or intersect == false then
							--print("Showing " .. table.count(plots) .. " plots with color " .. color);
							if colCityCentersOnly == true and color ~= radColCityCenter then
								UILens.SetLayerHexesColoredArea( LENS_LAYER, eLocalPlayer, interPlots, radCol ); -- use default color
							else
								UILens.SetLayerHexesColoredArea( LENS_LAYER, eLocalPlayer, interPlots, color );
							end
						--end
					end
				end
			end
		end

		--print("HighlightMapHexes #", 4, targetPlotId, table.count(notDimPlot) );
		if not disableDimming and table.count(notDimPlot) > 0 then
			--print("Showing notDimPlots ", table.count(notDimPlot));
			UILens.SetLayerHexesArea(MAP_HEX_MASK, Game.GetLocalPlayer(), notDimPlot );  
			
			UILens.ToggleLayerOn( MAP_HEX_MASK );
		else
			UILens.ToggleLayerOff( MAP_HEX_MASK );
		end

		
		UILens.ToggleLayerOn( LENS_LAYER );
	end

	LuaEvents.RmtClearSettlementRecommendations();
	LuaEvents.RmtAddSettlementRecommendations(targetPlotId, targetPlotIds, radius, enableSuggestions, multiRadius, ignoreVisibility );
end

--******************************************************************************
-- Populate Combo Box (Pull Down)
function PopulateComboBox(control, values, selected_value, selection_handler)

	control:ClearEntries();
	for i, v in ipairs(values) do
		local instance = {};
		control:BuildEntry( "InstanceOne", instance );
		instance.Button:SetVoid1(i);
        --instance.Button:LocalizeAndSetText(v[1]);
		instance.Button:SetText(v.Text);

		if(v.Key == selected_value) then
			local button = control:GetButton();
            button:SetText(v.Text);
			--button:SetSizeX(control:GetSizeX()-30);	
		end
	end
	control:CalculateInternals();	

	if(selection_handler) then
		control:RegisterSelectionCallback(
			function(voidValue1, voidValue2, control)
				local option = values[voidValue1];

				local button = control:GetButton();
                --button:LocalizeAndSetText(option[1]);
				button:SetText(option.Text);
				--button:SetSizeX(control:GetSizeX()-30);	
				--button:SetSizeY(control:GetSizeY());	
				selection_handler(option.Key);
			end
		);
	end
    	
end

--************************************************************
-- Refresh radius pull down GUI component
RefreshRadiusCB =  function ()
	local altDistance = Controls.RmtAltCntCB:IsChecked();
	unitCntLBEntries = {};
	for i = 1, 20, 1 do
		local displayDistance = i;
		if altDistance == true then
			displayDistance = i - 1;
			if i == 7 then 
				table.insert(unitCntLBEntries, { Key = i, Text = "[COLOR_GREEN]"      .. Locale.Lookup("LOC_RMT_ALT_RAD_PREFIX") .. " " .. displayDistance .. " " .. Locale.Lookup("LOC_RMT_ALT_RAD_SUFIX") .. "[ENDCOLOR]" , Index = i });
			elseif i < 7 then 
				table.insert(unitCntLBEntries, { Key = i, Text = "" .. Locale.Lookup("LOC_RMT_ALT_RAD_PREFIX") .. " " .. displayDistance .. " " .. Locale.Lookup("LOC_RMT_ALT_RAD_SUFIX") .. "" , Index = i });
			else
				table.insert(unitCntLBEntries, { Key = i, Text = "[COLOR_Grey]"       .. Locale.Lookup("LOC_RMT_ALT_RAD_PREFIX") .. " " .. displayDistance .. " " .. Locale.Lookup("LOC_RMT_ALT_RAD_SUFIX") .. "[ENDCOLOR]" , Index = i });
			end
		else
			if i == 4 then 
				table.insert(unitCntLBEntries, { Key = i, Text = "[COLOR_GREEN]" .. i .. " " .. Locale.Lookup("LOC_RMT_MAX_CITY_RAD") .. "[ENDCOLOR]", Index = i });
			elseif i < 6 then 
				table.insert(unitCntLBEntries, { Key = i, Text = i, Index = i });
			else
				table.insert(unitCntLBEntries, { Key = i, Text = "[COLOR_Grey]" .. i ..  "[ENDCOLOR]", Index = i });
			end
		end
		
		
	end
	local radiusCached = radius;

	Controls.RmtCntPD:ClearEntries();
    PopulateComboBox(Controls.RmtCntPD, unitCntLBEntries, radius + 1, 
        function(Key)
	    	radius = Key - 1;
			
			if radius ~= nil and targetPlotId ~= nil then
				--CollectData(targetPlotId);

				if isShownRmt then
					HighlightMapHexes();
				end
			end
	    end
    );
end

--************************************************************
function AddKeyEntry(textString:string, colorValue:number)
	local keyEntryInstance:table = m_KeyStackIM:GetInstance();

	-- Update key text
	keyEntryInstance.KeyLabel:SetText(Locale.Lookup(textString));

	-- Update key color
	
	keyEntryInstance.KeyColorImageBg:SetColor(UI.GetColorValue("COLOR_GREY"));
	keyEntryInstance.KeyColorImage:SetColor(colorValue);
	keyEntryInstance.KeyColorImageTop:SetColor(colorValue);

	-- If bonus icon or bonus value show the bonus stack
	--if bonusIcon or bonusValue then
		--keyEntryInstance.KeyBonusStack:SetHide(false);
		--keyEntryInstance.KeyBonusStack:CalculateSize();
	--else
		--keyEntryInstance.KeyBonusStack:SetHide(true);
	--end

	keyEntryInstance.KeyInfoStack:CalculateSize();
	keyEntryInstance.KeyInfoStack:ReprocessAnchoring();
end


--************************************************************
function AddResEntry( instanceManager, resType, resLbl )
	local resourceInfo = GameInfo.Resources[resType];
	if resourceInfo == nil then
		return;
	end
		
	local resourceType:string = resourceInfo.ResourceType;
	local resourceTextIcon = "[ICON_"..resourceType.."] ";

	local resEntryInstance:table = instanceManager:GetInstance();
		
		
	resEntryInstance.ResLabel:SetText(resLbl .. resourceTextIcon );
	resEntryInstance.ResLabel:SetToolTipString( Locale.Lookup("LOC_RMT_RES_TT", Locale.Lookup(resourceInfo.Name)) );

	resEntryInstance.RmtStackRes:CalculateSize();
	resEntryInstance.RmtStackRes:ReprocessAnchoring();
	
end

--************************************************************
function AddResOFlowEntry( instanceManager )
	local resEntryInstance:table = instanceManager:GetInstance();
		
	resEntryInstance.ResLabel:SetText(Locale.Lookup("LOC_RMT_RES_OVERFLOW"));
	resEntryInstance.ResLabel:SetToolTipString(Locale.Lookup("LOC_RMT_RES_OVERFLOW_TT"));

	resEntryInstance.RmtStackRes:CalculateSize();
	resEntryInstance.RmtStackRes:ReprocessAnchoring();
	
end


--************************************************************
-- calculate yield diff
local calculateYieldDiff = function ( yType, plotId, oldPlotId )
	--local localPlayer   :number = Game.GetLocalPlayer();
	--local localPlayerVis:table = PlayersVisibility[localPlayer];
	if plotId == nil or radiusYields[plotId] == nil then
		return 0, 0, 0;
	end

	local radYields = radiusYields[plotId];
	local newYieldCounter = radYields[yType];
	if newYieldCounter == nil then
		return 0, 0, 0;
	end

	local oldYieldCounter = nil;
	if oldPlotId ~= nil and radiusYields[oldPlotId] ~= nil then
		oldYieldCounter = radiusYields[oldPlotId][yType];
	end

	local diffYieldCounter = 0;
	
	if oldYieldCounter ~= nil then
		diffYieldCounter = newYieldCounter - oldYieldCounter;
	end
	
	-- update old counter
	--oldYieldCounters[yieldType] = newYieldCounter;

	return oldYieldCounter, newYieldCounter, diffYieldCounter;
end

--************************************************************
-- calculate yield diff
local calculateResDiff = function ( plotId, oldPlotId )

	local radRes = radiusSRes[plotId];
	local pRadRes = {};
	if oldPlotId ~= nil and radiusSRes[oldPlotId] ~= nil then
		pRadRes = radiusSRes[oldPlotId];
	end

	local resUnchS = {}; -- unchanged resources Strat
	local resAddS = {}; -- added resources Strat
	local resRemS = {}; -- removed resources Strat
	
	local resUnchL = {}; -- unchanged resources Lux
	local resAddL = {}; -- added resources Lux
	local resRemL = {}; -- removed resources Lux
		

	if radRes ~= nil then
		-- count unchanged/add resources Strat
		for res, rcnt in pairs( radRes ) do
			
			local unchanged = false;
			for pRes, pRCnt in pairs( pRadRes ) do
				if pRes == res then
					unchanged = true;
					break;
				end
			end
			if unchanged then 
				resUnchS[res] = res;
			else
				resAddS[res] = res;
			end
		end

		-- count removed resources Strat
		for pRes, pRCnt in pairs( pRadRes ) do
			if resUnchS[pRes] == nil and resAddS[pRes] == nil then
				resRemS[pRes] = pRes;
			end
			
		end
	end

	radRes = radiusLRes[plotId];
	pRadRes = {};
	if oldPlotId ~= nil and radiusLRes[oldPlotId] ~= nil then
		pRadRes = radiusLRes[oldPlotId];
	end

	if radRes ~= nil then
		-- count unchanged/add resources Strat
		for res, rcnt in pairs( radRes ) do
			
			local unchanged = false;
			for pRes, pRCnt in pairs( pRadRes ) do
				if pRes == res then
					unchanged = true;
					break;
				end
			end
			if unchanged then 
				resUnchL[res] = res;
			else
				resAddL[res] = res;
			end
		end

		-- count removed resources Strat
		for pRes, pRCnt in pairs( pRadRes ) do
			if resUnchL[pRes] == nil and resAddL[pRes] == nil then
				resRemL[pRes] = pRes;
			end
			
		end
	end

	return resUnchS, resAddS, resRemS, resUnchL, resAddL, resRemL;
end

--************************************************************
--format colored diff counters string
local formatCounterString = function ( oldTileCounter, newTileCounter, diffTileCounter, disableBaseColor )
	local res = "";

	local newCntCol = "[COLOR_FLOAT_GOLD]";
	local oldCntColPlus = "[COLOR_GREEN]";
	local oldCntColMin = "[COLOR_RED]";
	local endCol = "[ENDCOLOR]";

	local prefix = " x ";
	local delim = " (";
	local delim2 = ") ";
	
	if not disableBaseColor then
		res = res .. newCntCol;
	end
	res = res .. prefix .. newTileCounter;
	if not disableBaseColor then
		res = res .. endCol;
	end

	if diffTileCounter == 0 then
		--res = res .. delim .. diffTileCounter .. endCol;
	elseif diffTileCounter > 0 then
		res = res .. oldCntColPlus .. delim .. "+" .. diffTileCounter .. delim2 .. endCol;
	elseif diffTileCounter < 0 then
		res = res .. oldCntColMin .. delim .. diffTileCounter .. delim2 .. endCol;
	end

	--print(res, oldTileCounter, newTileCounter, diffTileCounter );
	return res;
end

--************************************************************
-- calculate and refresh Tiles and Yields on GUI
UpdateUiCounters = function ( isMain )
	m_KeyStackIM: ResetInstances();
	m_resSStackIM: ResetInstances();
	m_resLStackIM: ResetInstances();

	AddKeyEntry( Locale.Lookup("LOC_RMT_KEY_CITY_CEN") .. formatCounterString( calculateTiles( radColCityCenter ) ) , radColCityCenter );

	AddKeyEntry( Locale.Lookup("LOC_RMT_KEY_RES") .. formatCounterString( calculateTiles( radColRes ) ) , radColRes );	
	AddKeyEntry( Locale.Lookup("LOC_RMT_KEY_RES_WATER") .. formatCounterString( calculateTiles( radColCityResWater ) ) , radColCityResWater );
	AddKeyEntry( Locale.Lookup("LOC_RMT_KEY_RES_RANGE") .. formatCounterString( calculateTiles( radColCityResPretend ) ) , radColCityResPretend );
	AddKeyEntry( Locale.Lookup("LOC_RMT_KEY_RES_OWNED") .. formatCounterString( calculateTiles( radColCityResOwned ) ) , radColCityResOwned );

	AddKeyEntry( Locale.Lookup("LOC_RMT_KEY_TILE_RANGE") .. formatCounterString( calculateTiles( radColCityPretend ) ) , radColCityPretend );
	AddKeyEntry( Locale.Lookup("LOC_RMT_KEY_TILE_OWNED") .. formatCounterString( calculateTiles( radColCityOwned ) ) , radColCityOwned );
	AddKeyEntry( Locale.Lookup("LOC_RMT_KEY_TILE_NOT_PASS") .. formatCounterString( calculateTiles( radColNotPass ) ) , radColNotPass );
	AddKeyEntry( Locale.Lookup("LOC_RMT_KEY_TILE_WATER") .. formatCounterString( calculateTiles( radColWater ) ) , radColWater );

	AddKeyEntry( Locale.Lookup("LOC_RMT_KEY_TILE_NOTHING") , radCol );
	
	--Controls.KeyPanel:SetHide(false);
	Controls.KeyScrollPanel:CalculateSize();
	Controls.RmtStack22:CalculateSize();
	Controls.RmtStack22:ReprocessAnchoring();


	-- yields 
	local formatPattern = "%s";
	Controls.RmtYieldsLbl1:SetText("[ICON_FOOD] " .. string.format( formatPattern, formatCounterString( calculateYieldDiff( YieldTypes.FOOD, targetPlotId, getOldRadiusPlotId() ) ) ));
	Controls.RmtYieldsLbl1:SetToolTipString( Locale.Lookup("LOC_RMT_YIELDS_TT") );
	Controls.RmtYieldsLbl2:SetText("[ICON_Production] "  .. string.format( formatPattern, formatCounterString( calculateYieldDiff( YieldTypes.PRODUCTION, targetPlotId, getOldRadiusPlotId() ) ) ));
	Controls.RmtYieldsLbl2:SetToolTipString( Locale.Lookup("LOC_RMT_YIELDS_TT") );
	Controls.RmtYieldsLbl3:SetText("[ICON_Gold] "  .. string.format( formatPattern, formatCounterString( calculateYieldDiff( YieldTypes.GOLD, targetPlotId, getOldRadiusPlotId() ) ) ));
	Controls.RmtYieldsLbl3:SetToolTipString( Locale.Lookup("LOC_RMT_YIELDS_TT") );
	Controls.RmtYieldsLbl4:SetText("[ICON_Science] "  .. string.format( formatPattern, formatCounterString( calculateYieldDiff( YieldTypes.SCIENCE, targetPlotId, getOldRadiusPlotId() ) ) ));
	Controls.RmtYieldsLbl4:SetToolTipString( Locale.Lookup("LOC_RMT_YIELDS_TT") );
	Controls.RmtYieldsLbl5:SetText("[ICON_Culture] "  .. string.format( formatPattern, formatCounterString( calculateYieldDiff( YieldTypes.CULTURE, targetPlotId, getOldRadiusPlotId() ) ) ));
	Controls.RmtYieldsLbl5:SetToolTipString( Locale.Lookup("LOC_RMT_YIELDS_TT") );
	Controls.RmtYieldsLbl6:SetText("[ICON_Faith] "  .. string.format( formatPattern, formatCounterString( calculateYieldDiff( YieldTypes.FAITH, targetPlotId, getOldRadiusPlotId() ) ) ));
	Controls.RmtYieldsLbl6:SetToolTipString( Locale.Lookup("LOC_RMT_YIELDS_TT") );
	
	if isMain then 
		-- resources Strat
		local colPlus = "[COLOR_GREEN]";
		local colMin = "[COLOR_RED]";
		local endCol = "[ENDCOLOR]";

		-- count -- unchanged resources -- added resources -- removed resources
		local resUnchS, resAddS, resRemS, resUnchL, resAddL, resRemL = calculateResDiff( targetPlotId, getOldRadiusPlotId() );

		
		local maxCnt = 9;
		local dispCnt = 0;
		local oFlowCnt = 0;

		-- display res strat
		for res, res2 in pairs( resUnchS ) do
			if dispCnt < maxCnt then
				AddResEntry( m_resSStackIM, res, "" );
				dispCnt = dispCnt + 1;
			else 
				oFlowCnt = oFlowCnt + 1;
			end
		end
		for res, res2 in pairs( resAddS ) do
			if dispCnt < maxCnt then
				AddResEntry( m_resSStackIM, res, colPlus .. "+" .. endCol );
				dispCnt = dispCnt + 1;
			else 
				oFlowCnt = oFlowCnt + 1;
			end
		end
		for res, res2 in pairs( resRemS ) do
			if dispCnt < maxCnt then
				AddResEntry( m_resSStackIM, res, colMin .. "-" .. endCol );
				dispCnt = dispCnt + 1;
			else 
				oFlowCnt = oFlowCnt + 1;
			end
		end
		if oFlowCnt > 0 then
			AddResOFlowEntry(m_resSStackIM);
		end
		

		-- lux resources
		dispCnt = 0;
		oFlowCnt = 0;

		-- display res strat
		for res, res2 in pairs( resUnchL ) do
			if dispCnt < maxCnt then
				AddResEntry( m_resLStackIM, res, "" );
				dispCnt = dispCnt + 1;
			else 
				oFlowCnt = oFlowCnt + 1;
			end
		end
		for res, res2 in pairs( resAddL ) do
			if dispCnt < maxCnt then
				AddResEntry( m_resLStackIM, res, colPlus .. "+" .. endCol );
				dispCnt = dispCnt + 1;
			else 
				oFlowCnt = oFlowCnt + 1;
			end
		end
		for res, res2 in pairs( resRemL ) do
			if dispCnt < maxCnt then
				AddResEntry( m_resLStackIM, res, colMin .. "-" .. endCol );
				dispCnt = dispCnt + 1;
			else 
				oFlowCnt = oFlowCnt + 1;
			end
		end
		if oFlowCnt > 0 then
			AddResOFlowEntry(m_resLStackIM);
		end
		
	end -- if isMain

end

--************************************************************
-- Callaback of the RMT top UI button click
local function OnTopBtnClick()
	--print( " ################ OnTopBtnClick", true );
	btnClick = true;
	if isShownRmt then
		isShownRmt = false;
		FixUiMode();
		HideDlg();
	else
		isShownRmt = true;
		FixUiMode();
		ShowDlg();
	end
	
end

--******************************************************************************
function OnRmtSuggestionsCBClick()
	enableSuggestions = Controls.RmtSuggestionsCB:IsChecked();
	HighlightMapHexes();
end

--******************************************************************************
function OnRmtImportantResourcesOnlyCBClick()
	importantResourcesOnly = Controls.RmtImportantResourcesOnlyCB:IsChecked();
	HighlightMapHexes();
end

--******************************************************************************
function OnRmtVisibilityCBClick()
	ignoreVisibility = Controls.RmtVisibilityCB:IsChecked();
	HighlightMapHexes();
end

--******************************************************************************
function OnCityCentersOnlyCBClick()
	colCityCentersOnly = Controls.RmtCityCentersOnlyCB:IsChecked();
	HighlightMapHexes();
end

--******************************************************************************
function OnRmtBackgroundCBClick()
	transpBackground = Controls.RmtBackgroundCB:IsChecked();
	Controls.RmtSpawnDlgBG:SetHide( transpBackground );
	--Controls.RmtSpawnDlgContainer:SetHide( true );
	--Controls.RmtSpawnDlgContainer:SetHide( false );
end

--******************************************************************************
function OnRmtDoubleRadiusCBClick()
	multiRadius = Controls.RmtDoubleRadiusCB:IsChecked();
	HighlightMapHexes();
end

--******************************************************************************
function OnRmtIntersectCBClick()
	disableIntersects = Controls.RmtIntersectCB:IsChecked();
	HighlightMapHexes();
end

--******************************************************************************
function OnRmtDimmingCBClick()
	disableDimming = Controls.RmtDimmingCB:IsChecked();
	HighlightMapHexes();
end

--******************************************************************************
function OnRmtWndPosLeftCBClick()
	if Controls.RmtWndPosLeftCB:IsChecked() then
		SetAnchorLeft();
	end

	-- if nothing checked
	if not Controls.RmtWndPosLeftCB:IsChecked() and not Controls.RmtWndPosCentrCB:IsChecked() and not Controls.RmtWndPosRightCB:IsChecked() then
		Controls.RmtWndPosLeftCB:SetCheck(true);
	end
end

--******************************************************************************
function OnRmtWndPosCentrCBClick()
	if Controls.RmtWndPosCentrCB:IsChecked() then
		SetAnchorCentr();
	end
	
	-- if nothing checked
	if not Controls.RmtWndPosLeftCB:IsChecked() and not Controls.RmtWndPosCentrCB:IsChecked() and not Controls.RmtWndPosRightCB:IsChecked() then
		Controls.RmtWndPosCentrCB:SetCheck(true);
	end
end

--******************************************************************************
function OnRmtWndPosRightCBClick()
	if Controls.RmtWndPosRightCB:IsChecked() then
		SetAnchorRight();
	end
		
	-- if nothing checked
	if not Controls.RmtWndPosLeftCB:IsChecked() and not Controls.RmtWndPosCentrCB:IsChecked() and not Controls.RmtWndPosRightCB:IsChecked() then
		Controls.RmtWndPosRightCB:SetCheck(true);
	end
end

--******************************************************************************
local function OnSelectPlot(plotId, plotEdge, boolParam)
	if not isShownRmt then
		return;
	end
	--CollectData(plotId);
	--oldTargetPlotId = targetPlotId;
	--table.insert(targetPlotIds, targetPlotId);
	--print(" Selected plot: ", 1, plotId);
	updateOldPlotId( plotId );
	--print(" Selected plot: ", 2, plotId);
	targetPlotId = plotId;
	HighlightMapHexes();
	--print(" Selected plot: ", 3, plotId);
end

--******************************************************************************
function OnInputHandler( pInputStruct:table )
	local msg = pInputStruct:GetMessageType();
	--if isShownRmt and btnClick == false then 
		--local msg = pInputStruct:GetMessageType();
		--if msg == MouseEvents.LButtonUp then
			--oldTargetPlotId = targetPlotId;
			--targetPlotId = UI.GetCursorPlotID();
			--print("OnInput ## LButtonUp", pInputStruct:GetX(), pInputStruct:GetY(), oldTargetPlotId, targetPlotId);
			----CollectData();
			--HighlightMapHexes();
		--end
	--end
	--if btnClick == true then 
		--print("OnInput ## LButtonUp Ignoring Btn Click", targetPlotId);
		---- ignore click on mod panel btn
		--btnClick = false;
	--end

	--hotkeys
	if msg == KeyEvents.KeyUp then
		local key = pInputStruct:GetKey();
		--print(" Key: ", key);
		if isShownRmt and key == Keys.VK_ESCAPE then
			OnTopBtnClick();
			return true;
		end
		-- Keys.VK_4 ???
		if key == 31  and pInputStruct:IsAltDown() and not pInputStruct:IsShiftDown()  and not pInputStruct:IsControlDown() then
			-- 31 == keyboard key [4]
			OnTopBtnClick();
			return true;
		end
		--for i, k in pairs(Keys) do
		--	print(" Key: ", i, k);
		--end
	end


    --return false;
end

--******************************************************************************
function OnLensLayerOn( lNum:number )
    if isShownRmt and lNum == LENS_LAYER then
        --UILens.SetDesaturation(0.3);
		HighlightMapHexes();

		Controls.RmtSpawnDlgContainer:SetHide( true );
		Controls.RmtSpawnDlgContainer:SetHide( false );
	end
end

--******************************************************************************
function OnLensLayerOff( lNum:number )
    if lNum == LENS_LAYER then
		UILens.ClearLayerHexes(LENS_LAYER);
        --UILens.SetDesaturation(0.0);
	end
end

--******************************************************************************
local function OnRmtMapPinRClick( plotId )
	--CollectData(plotId);
	--oldTargetPlotId = targetPlotId;
	--table.insert(targetPlotIds, targetPlotId);
	--print(" OnRmtMapPinRClick: ", 1, plotId);
	--updateOldPlotId( plotId );
	--targetPlotId = plotId;
	removeOldPlotId( plotId )
	HighlightMapHexes();
end

--******************************************************************************
local function OnRmtMapPinLClick( plotId )
	--CollectData(plotId);
	--oldTargetPlotId = targetPlotId;
	--table.insert(targetPlotIds, targetPlotId);
	--print(" OnRmtMapPinLClick: ", 1, plotId);
	updateOldPlotId( plotId );
	targetPlotId = plotId;
	--removeOldPlotId( plotId )
	HighlightMapHexes();
end

--************************************************************
local function LateInit()
	print( " ################ Start Initializing Mod RMT UI Script... ################ " );
	OnLoadGameViewStateDone();
	--Events.LoadGameViewStateDone.Add( OnLoadGameViewStateDone );
	Events.InterfaceModeChanged.Add( OnUiModChange );

	LuaEvents.WorldInput_WBSelectPlot.Add( OnSelectPlot );

	LuaEvents.RmtMapPinRClick.Add( OnRmtMapPinRClick );
	LuaEvents.RmtMapPinLClick.Add( OnRmtMapPinLClick );
	--LuaEvents.RmtGetYieldsCountString.Add( 
	ExposedMembers.MOD_RMT = {};
	ExposedMembers.MOD_RMT.RmtGetYieldsCountString = 
		function ( yType, plotId1, plotId2 ) 
			--print("RmtGetYieldsCountString 1 ", yType, plotId1, plotId2 );
			local ctr1, ctr2, ctr3 = calculateYieldDiff( yType, plotId1, plotId2 );
			--print("RmtGetYieldsCountString 2 ", ctr1, ctr2, ctr3 );
			local res = formatCounterString( ctr1, ctr2, ctr3, true );
			--print("RmtGetYieldsCountString 3 ", ctr1, ctr2, ctr3, res );
			return res; 
		end 
	--)
	;

	ExposedMembers.MOD_RMT.RmtGetResCountString = 
		function ( plotId1, plotId2 ) 
			--print("RmtGetYieldsCountString 1 ", yType, plotId1, plotId2 );
			-- resources Strat
			local colPlus = "[COLOR_GREEN]";
			local colMin = "[COLOR_RED]";
			local endCol = "[ENDCOLOR]";
			
			local resStr = "";

			-- count -- unchanged resources -- added resources -- removed resources
			local resUnchS, resAddS, resRemS, resUnchL, resAddL, resRemL = calculateResDiff( plotId1, plotId2 );

			-- display res strat
			for res, res2 in pairs( resUnchS ) do
				local resourceInfo = GameInfo.Resources[res];
				if resourceInfo ~= nil then
					local resourceType:string = resourceInfo.ResourceType;
					local resourceTextIcon = "[ICON_"..resourceType.."] " .. "    ";
					resStr = resStr .. resourceTextIcon;
					--print("RmtGetResCountString unch", resourceType);
				end
			end
			for res, res2 in pairs( resAddS ) do
				local resourceInfo = GameInfo.Resources[res];
				if resourceInfo ~= nil then
					local resourceType:string = resourceInfo.ResourceType;
					local resourceTextIcon = "[ICON_"..resourceType.."] ";
					resStr = resStr .. colPlus .. "+" .. endCol .. resourceTextIcon .. "    ";
					--print("RmtGetResCountString add", resourceType);
				end
			end
			for res, res2 in pairs( resRemS ) do
				local resourceInfo = GameInfo.Resources[res];
				if resourceInfo ~= nil then
					local resourceType:string = resourceInfo.ResourceType;
					local resourceTextIcon = "[ICON_"..resourceType.."] ";
					resStr = resStr .. colMin .. "-" .. endCol .. resourceTextIcon .. "    ";
					--print("RmtGetResCountString rem", resourceType);
				end
			end

			-- lux resources
			resStr = resStr .. "[NEWLINE]";

			for res, res2 in pairs( resUnchL ) do
				local resourceInfo = GameInfo.Resources[res];
				if resourceInfo ~= nil then
					local resourceType:string = resourceInfo.ResourceType;
					local resourceTextIcon = "[ICON_"..resourceType.."] ";
					resStr = resStr .. resourceTextIcon .. "    ";
				end
			end
			for res, res2 in pairs( resAddL ) do
				local resourceInfo = GameInfo.Resources[res];
				if resourceInfo ~= nil then
					local resourceType:string = resourceInfo.ResourceType;
					local resourceTextIcon = "[ICON_"..resourceType.."] ";
					resStr = resStr .. colPlus .. "+" .. endCol .. resourceTextIcon .. "    ";
				end
			end
			for res, res2 in pairs( resRemL ) do
				local resourceInfo = GameInfo.Resources[res];
				if resourceInfo ~= nil then
					local resourceType:string = resourceInfo.ResourceType;
					local resourceTextIcon = "[ICON_"..resourceType.."] ";
					resStr = resStr .. colMin .. "-" .. endCol .. resourceTextIcon .. "    ";
				end
			end

			return resStr; 
		end 
	;

	Controls.RmtAltCntCB:RegisterCallback(		Mouse.eLClick, RefreshRadiusCB );
	Controls.RmtSuggestionsCB:RegisterCallback(		Mouse.eLClick, OnRmtSuggestionsCBClick );
	Controls.RmtImportantResourcesOnlyCB:RegisterCallback(		Mouse.eLClick, OnRmtImportantResourcesOnlyCBClick );
	Controls.RmtVisibilityCB:RegisterCallback(		Mouse.eLClick, OnRmtVisibilityCBClick );
	Controls.RmtCityCentersOnlyCB:RegisterCallback(	Mouse.eLClick, OnCityCentersOnlyCBClick );
	Controls.RmtDoubleRadiusCB:RegisterCallback(		Mouse.eLClick, OnRmtDoubleRadiusCBClick );
	Controls.RmtIntersectCB:RegisterCallback(		Mouse.eLClick, OnRmtIntersectCBClick );
	Controls.RmtDimmingCB:RegisterCallback(		Mouse.eLClick, OnRmtDimmingCBClick );
	
	Controls.RmtWndPosLeftCB:RegisterCallback(		Mouse.eLClick, OnRmtWndPosLeftCBClick );
	Controls.RmtWndPosCentrCB:RegisterCallback(		Mouse.eLClick, OnRmtWndPosCentrCBClick );
	Controls.RmtWndPosRightCB:RegisterCallback(		Mouse.eLClick, OnRmtWndPosRightCBClick );
	
	Controls.RmtBackgroundCB:RegisterCallback(		Mouse.eLClick, OnRmtBackgroundCBClick );

    ContextPtr:SetInputHandler( OnInputHandler, true );
    Events.LensLayerOn.Add( OnLensLayerOn );
    Events.LensLayerOff.Add( OnLensLayerOff );

	-- UI Callbacks
	--ContextPtr:SetRefreshHandler( OnRefresh );
	Controls.RmtLaunchBarBtnTimer:RegisterEndCallback( OnTopBtnClick );
	Controls.RmtLaunchBarBtn:RegisterCallback( Mouse.eLClick, function() Controls.RmtLaunchBarBtnTimer:SetToBeginning(); Controls.RmtLaunchBarBtnTimer:Play(); end );
	
	if Mod_RMT_Transparent_Background ~= nil then
		transpBackground = Mod_RMT_Transparent_Background;
		Controls.RmtBackgroundCB:SetCheck( transpBackground );
		print(" Applied default transparent background", transpBackground);
	end
	
	if Mod_RMT_Window_Position ~= nil then
		if Mod_RMT_Window_Position == 1 then
			Controls.RmtWndPosLeftCB:SetCheck( true );
			OnRmtWndPosLeftCBClick();
		elseif Mod_RMT_Window_Position == 2 then
			Controls.RmtWndPosCentrCB:SetCheck( true );
			OnRmtWndPosCentrCBClick();
		elseif Mod_RMT_Window_Position == 3 then
			Controls.RmtWndPosRightCB:SetCheck( true );
			OnRmtWndPosRightCBClick();
		end
		print(" Applied default window position", Mod_RMT_Window_Position);
	end

	ContextPtr:SetHide(false);
	print( " ################ End Initializing Mod RMT UI Script... ################ " );
	LuaEvents.ModRmt_UiInit(); -- notify listeners
end


--************************************************************
local function Initialize()
	Events.LoadGameViewStateDone.Add( LateInit );
end

Initialize();
